Imports SAP.Connector

Class App

    Shared Sub Main()

        Dim smt As theosclient

        smt = New theosclient("CLIENT=0 USER=Theobald PASSWD=pw LANG=DE ASHOST=lovemachine SYSNR=0")
        smt.Connection.Open()

        Dim Tabelle As New FIELDSTable
        Dim TabLength As Integer
        Dim Tabname As String

        Console.WriteLine("Bitte den Name der Struktur oder ")
        Console.WriteLine("der transparanten Tabelle angeben ...")
        Tabname = Console.ReadLine()

        smt.RFC_GET_STRUCTURE_DEFINITION(Tabname, TabLength, Tabelle)

        Dim Fields As FIELDS

        Console.WriteLine("Gesamtbreite: " & TabLength.ToString)

        Console.WriteLine("Feldname".PadRight(30) & "" & _
            "Lnge".PadRight(10) & "ABAP-Typ".PadRight(10))
        Console.WriteLine("-".PadRight(50, "-"))

        For Each fields In Tabelle
            Console.WriteLine(Fields.FIELDNAME.PadRight(30) & _
                Fields.INTLENGTH.ToString.PadRight(10) & _
                Fields.EXID)
        Next

        Console.WriteLine("-".PadRight(50, "-"))

        Console.ReadLine()

    End Sub

End Class

Class theosclient
    Inherits SAP.Connector.SAPClient

    <SAP.Connector.RfcMethod(AbapName:="RFC_GET_STRUCTURE_DEFINITION")> _
    Public Function RFC_GET_STRUCTURE_DEFINITION( _
               <SAP.Connector.RfcParameter(AbapName:="TABNAME", _
                  RFCTYPE:=RFCTYPE.RFCTYPE_CHAR, _
                 Optional:=False, Direction:=RFCINOUT.IN, _
                Length:=30)> ByVal TABNAME As String, _
                <RfcParameter(AbapName:="TABLENGTH", _
                   RFCTYPE:=RFCTYPE.RFCTYPE_INT, _
                  Optional:=True, Direction:=RFCINOUT.OUT, _
                 Length:=4)> ByRef TABLENGTH As Integer, _
                <RfcParameter(AbapName:="FIELDS", _
                   RFCTYPE:=RFCTYPE.RFCTYPE_ITAB, _
                  Direction:=RFCINOUT.INOUT _
                 )> ByRef FIELDSTable As FIELDSTable) _
        As Boolean


        Dim ColOut() As Object = {TABNAME, FIELDSTable}
        Dim ColIn() As Object

        ColIn = MyBase.SAPInvoke("RFC_GET_STRUCTURE_DEFINITION", ColOut)

        Try
            ColIn = MyBase.SAPInvoke("RFC_GET_STRUCTURE_DEFINITION", ColOut)
        Catch ex As Exception
            Console.WriteLine(ex.ToString)
            Return False
        End Try

        TABLENGTH = ColIn(0)
        FIELDSTable = ColIn(1)

        Return True

    End Function
    Public Sub New(ByVal Dest As String)
        MyBase.New(Dest)
    End Sub

End Class

<SAP.Connector.RfcStructure(AbapName:="FIELDS", _
Length:=77)> _
Public Class FIELDS : Inherits SAP.Connector.SAPStructure

    Private p_TABNAME As String
    Private p_FIELDNAME As String
    Private p_POSITION As Integer
    Private p_OFFSET As Integer
    Private p_INTLENGTH As Integer
    Private p_DECIMALS As Integer
    Private p_EXID As String
    <SAP.connector.RfcField(AbapName:="TABNAME", _
        RFCTYPE:=SAP.Connector.RFCTYPE.RFCTYPE_CHAR, _
        Length:=30, OFFSET:=0)> _
    Property TABNAME() As String
        Get
            Return p_TABNAME
        End Get
        Set(ByVal Value As String)
            p_TABNAME = Value
        End Set
    End Property

    <SAP.connector.RfcField(AbapName:="FIELDNAME", _
    RFCTYPE:=SAP.Connector.RFCTYPE.RFCTYPE_CHAR, _
    Length:=30, OFFSET:=30)> _
Property FIELDNAME() As String
        Get
            Return p_FIELDNAME
        End Get
        Set(ByVal Value As String)
            p_FIELDNAME = Value
        End Set
    End Property
    <SAP.connector.RfcField(AbapName:="POSITION", _
    RFCTYPE:=RFCTYPE.RFCTYPE_INT, _
    Length:=4, OFFSET:=60)> _
Property POSITION() As Integer
        Get
            Return p_POSITION
        End Get
        Set(ByVal Value As Integer)
            p_POSITION = Value
        End Set
    End Property

    <RfcField(AbapName:="OFFSET", _
RFCTYPE:=RFCTYPE.RFCTYPE_INT, _
Length:=4, OFFSET:=64)> _
Property OFFSET() As Integer
        Get
            Return p_POSITION
        End Get
        Set(ByVal Value As Integer)
            p_POSITION = Value
        End Set
    End Property

    <RfcField(AbapName:="INTLENGTH", _
RFCTYPE:=RFCTYPE.RFCTYPE_INT, _
Length:=4, OFFSET:=68)> _
Property INTLENGTH() As Integer
        Get
            Return p_INTLENGTH
        End Get
        Set(ByVal Value As Integer)
            p_INTLENGTH = Value
        End Set
    End Property
    <RfcField(AbapName:="DECIMALS", _
RFCTYPE:=RFCTYPE.RFCTYPE_INT, _
Length:=4, OFFSET:=72)> _
Property DECIMALS() As Integer
        Get
            Return p_DECIMALS
        End Get
        Set(ByVal Value As Integer)
            p_DECIMALS = Value
        End Set
    End Property

    <RfcField(AbapName:="EXID", _
RFCTYPE:=RFCTYPE.RFCTYPE_CHAR, _
Length:=1, OFFSET:=76)> _
Property EXID() As String
        Get
            Return p_EXID
        End Get
        Set(ByVal Value As String)
            p_EXID = Value
        End Set
    End Property
End Class

Public Class FIELDSTable : Inherits SAP.Connector.SAPTable
    Shared Function GetElementType() As Type
        Dim smtDelete As New FIELDS
        Return smtDelete.GetType
    End Function

    Overrides Function CreateNewRow() As Object
        Return New FIELDS
    End Function

    Default Public Property Item(ByVal index _
As Integer) As FIELDS
        Get
            Return List(index)
        End Get
        Set(ByVal Value As FIELDS)
            List(index) = Value
        End Set
    End Property

    Public Function Add(ByVal value As FIELDS) _
As Integer
        Return List.Add(value)
    End Function

    Public Sub Insert(ByVal index As Integer, _
ByVal value As FIELDS)
        List.Insert(index, value)
    End Sub

    Public Function IndexOf(ByVal value As FIELDS) _
As Integer
        Return List.IndexOf(value)
    End Function

    Public Function Contains(ByVal value As FIELDS) As Boolean
        Return List.Contains(value)
    End Function

    Public Sub Remove(ByVal value As FIELDS)
        List.Remove(value)
    End Sub

    Public Sub CopyTo(ByVal array() As FIELDS, _
ByVal index As Integer)
        List.CopyTo(array, index)
    End Sub

End Class


